/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	ScaleObjects.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CEdit.h"
#include "CApplication.h"

HRESULT ScaleObjects(double scaleFactor, ISet *objectSet1)
{

//	Scales the object set with the given scaleFactor
//	and returns the scaled object set

	START_METHOD("ScaleObjects")

	HRESULT status = CONV_SUCCESS;
	IDispatch *pDisp = NULL;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IMatrix *scaleMatrix = NULL;
	status = (GetCLASS(Matrix))->CreateScaleMatrix(scaleFactor, &scaleMatrix);
	CHECK_RETURN_STATUS(status)

	// Transform the objects
	status = activeWorkplane->TransformObjects(CAST(IObjectOrSet, objectSet1), scaleMatrix);
	CHECK_RETURN_STATUS(status)

	END_METHOD("ScaleObjects")
}
